### 1. Defense-in-Depth Approach

- Effective network security requires multiple, integrated layers.
- The first layer is establishing a security baseline—core security measures for all devices.
- Security should address all three device planes:
    - **Control plane**
    - **Management plane**
    - **Data plane**

---

### 2. Securing Network Infrastructure

- Protecting routers, switches, servers, and infrastructure devices is crucial.
- **Management access security** is a key concern; compromised access can endanger the entire network.
- Prevent unauthorized access and maintain secure routing/switching infrastructure.
- Use network telemetry to improve visibility.

---

### 3. Developing a Security Baseline

- Wide variety of features makes standardizing a baseline challenging.
- Cisco Network Security Baseline identifies key elements for initial defense-in-depth:
    - Infrastructure device access
    - Routing infrastructure
    - Device resiliency and survivability
    - Network telemetry
    - Network policy enforcement
    - Switching infrastructure

---

### 4. Common Network Infrastructure Threats

- Denial of Service (DoS) attacks
- Distributed Denial of Service (DDoS) attacks
- Unauthorized access
- Session hijacking
- Man-in-the-middle attacks
- Privilege escalation
- Intrusions
- Botnets
- Routing protocol attacks
- Spanning tree attacks
- Layer 2 attacks

---

### 5. Functional Planes of Network Devices

- **Data Plane**
    - Handles data switching/routing and applies services (security, QoS, etc.)
- **Control Plane**
    - Builds routing, forwarding, and MAC address tables for correct data plane operation.
- **Management Plane**
    - Enables configuration and monitoring by administrators.

#### Shared CPU Resources

- Planes often share CPU resources (e.g., NAT and SSH may use the same CPU).
- Protecting one plane helps protect resources for all planes.

#### Shared Security Features

- Some features (e.g., infrastructure ACLs) can protect multiple planes.
    - Filtering traffic to management IP (protects management/control planes)
    - Filtering transit traffic (protects data plane)

#### High-End Routers

- In advanced devices (e.g., Cisco ASR 9000 Series), planes may use separate hardware resources.
- Analyze and apply best practices for each plane in such devices.

---

### 6. Security Controls Implementation

- Deploy protection controls on all network devices if possible.
- If not, prioritize the most exposed devices.
- Each device type offers different controls; design network to maximize effectiveness.

---

**Notes:**

- Always tailor controls to device capabilities and network design.
- Focus on both prevention (access controls, policy enforcement) and detection (telemetry, monitoring).